	function [Xnum, Xden] = S_2_X(Snum, Sden)
	
	% 	Computes the reactance corresponding to a reflectance S.
 
	% 	Toolbox for ANALOG FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2007-06-25
	% 	Modified by: 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1 
	% 	Known bugs:		None
	% 	Report bugs to:	Wanhammar@gmail.com
	%	To improve:		Check that S is a true reflection function	
	
	N = length(Sden);
	Xnum = POLYADD(ROOTS_2_POLY(Snum), ROOTS_2_POLY(Sden));
	Xden = POLYSUB(ROOTS_2_POLY(Sden), ROOTS_2_POLY(Snum));
	if abs(Xden(1)) < 100*eps
		Xden(1) = [];
	end
	Xnum = Xnum/Xden(1);
	Xden = Xden/Xden(1);	
	if length(Xnum) > length(Xden)
		Xden = [0, Xden];	
	end
	if length(Xnum) < length(Xden)
		Xnum = [Xnum, 0];	
	end	
